/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.thymeleaf;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;

final class ComponentProcessor
extends AbstractAttributeTagProcessor {
    ComponentProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, null, false, "component", true, 100, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        structureHandler.removeAttribute(attributeName);
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser(context.getConfiguration());
        IStandardExpression expression = expressionParser.parseExpression(context, attributeValue);
        Object result = expression.execute(context);
        String componentPath = result == null ? "" : result.toString();
        IComment model = context.getModelFactory().createComment("# COMPONENT " + componentPath + " ");
        structureHandler.setBody(model, false);
    }
}

